-- 创建系统设置表
CREATE TABLE system_settings (
    setting_id BIGINT AUTO_INCREMENT PRIMARY KEY COMMENT '设置ID',
    user_id BIGINT NOT NULL COMMENT '用户ID',
    study_reminder_enabled BOOLEAN DEFAULT TRUE COMMENT '学习提醒开关',
    focus_mode_enabled BOOLEAN DEFAULT TRUE COMMENT '专注模式开关',
    data_sync_enabled BOOLEAN DEFAULT FALSE COMMENT '数据同步开关',
    privacy_protection_enabled BOOLEAN DEFAULT TRUE COMMENT '隐私保护开关',
    night_mode_enabled BOOLEAN DEFAULT FALSE COMMENT '夜间模式开关',
    reminder_time VARCHAR(5) DEFAULT '09:00' COMMENT '提醒时间(HH:mm格式)',
    create_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    
    -- 添加索引
    UNIQUE KEY uk_user_id (user_id),
    INDEX idx_user_id (user_id),
    INDEX idx_create_time (create_time)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统设置表';

-- 为现有用户创建默认设置（可选）
-- INSERT INTO system_settings (user_id, study_reminder_enabled, focus_mode_enabled, data_sync_enabled, privacy_protection_enabled, night_mode_enabled, reminder_time)
-- SELECT user_id, TRUE, TRUE, FALSE, TRUE, FALSE, '09:00'
-- FROM user_info
-- WHERE user_id NOT IN (SELECT user_id FROM system_settings);