-- 创建成就表
CREATE TABLE achievements (
    achievement_id BIGINT PRIMARY KEY AUTO_INCREMENT COMMENT '成就ID',
    user_id BIGINT NOT NULL COMMENT '用户ID',
    achievement_type VARCHAR(50) NOT NULL COMMENT '成就类型',
    achievement_name VARCHAR(100) NOT NULL COMMENT '成就名称',
    description TEXT COMMENT '成就描述',
    icon_resource VARCHAR(255) COMMENT '成就图标资源路径',
    is_achieved TINYINT NOT NULL DEFAULT 0 COMMENT '是否已获得（0-未获得，1-已获得）',
    achieve_date TIMESTAMP NULL COMMENT '获得成就的日期',
    current_progress INT NOT NULL DEFAULT 0 COMMENT '当前进度',
    target_value INT NOT NULL COMMENT '目标值',
    create_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    FOREIGN KEY (user_id) REFERENCES user_info(user_id) ON DELETE CASCADE,
    UNIQUE KEY uk_user_achievement (user_id, achievement_type)
);

-- 创建索引以提高查询性能
CREATE INDEX idx_achievements_user_id ON achievements(user_id);
CREATE INDEX idx_achievements_type ON achievements(achievement_type);
CREATE INDEX idx_achievements_achieved ON achievements(is_achieved);
CREATE INDEX idx_achievements_user_achieved ON achievements(user_id, is_achieved);
CREATE INDEX idx_achievements_achieve_date ON achievements(achieve_date);
CREATE INDEX idx_achievements_progress ON achievements(current_progress, target_value);

-- 添加表注释
ALTER TABLE achievements COMMENT = '用户学习成就表，记录用户获得的各种学习成就';